/**
 * 
 */
package com.ejie.ab04b.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.HttpServletRequest;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.exception.ErrorGenericoException;
import com.ejie.ab04b.model.ApartadoAnexoI;
import com.ejie.ab04b.model.ApartadoAnexoII;
import com.ejie.ab04b.model.ClaseCentroTrabajo;
import com.ejie.ab04b.model.CnaeJ73;
import com.ejie.ab04b.model.EmpresaAuditora;
import com.ejie.ab04b.model.EmpresaServicioPrevencion;
import com.ejie.ab04b.model.EntidadGestoraColaboradora;
import com.ejie.ab04b.model.ModalidadOrganizacionPreventiva;
import com.ejie.ab04b.model.RegimenJuridico;
import com.ejie.ab04b.model.Secciones;
import com.ejie.ab04b.model.Tablones;
import com.ejie.ab04b.model.TecnicoOsalan;
import com.ejie.ab04b.model.TipoApertura;
import com.ejie.ab04b.model.TipoObra;
import com.ejie.ab04b.model.comun.ElementoCombo;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Pais;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.ab04b.service.ApartadoAnexoIIService;
import com.ejie.ab04b.service.ApartadoAnexoIService;
import com.ejie.ab04b.service.ClaseCentroTrabajoService;
import com.ejie.ab04b.service.CnaeJ73Service;
import com.ejie.ab04b.service.EmpresaAuditoraService;
import com.ejie.ab04b.service.EmpresaServicioPrevencionService;
import com.ejie.ab04b.service.EntidadGestoraColaboradoraService;
import com.ejie.ab04b.service.ModalidadOrganizacionPreventivaService;
import com.ejie.ab04b.service.RegimenJuridicoService;
import com.ejie.ab04b.service.SeccionesService;
import com.ejie.ab04b.service.TablonesService;
import com.ejie.ab04b.service.TecnicoOsalanService;
import com.ejie.ab04b.service.TipoAperturaService;
import com.ejie.ab04b.service.TipoObraService;
import com.ejie.ab04b.service.nora.LocalidadService;
import com.ejie.ab04b.service.nora.MunicipioService;
import com.ejie.ab04b.service.nora.PaisService;
import com.ejie.ab04b.service.nora.ProvinciaService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.seguridad.UtilSeguridad;
import com.ejie.x38.dto.JQGridRequestDto;
import com.gfi.utils.UtilWeb;

/**
 * ComboController
 * 
 * @author GFI
 */
@Controller()
@RequestMapping(value = "/combo")
public class ComboController {

	@Autowired()
	private TipoAperturaService tiposAperturasService;

	@Autowired()
	private ClaseCentroTrabajoService clasesCentrosTrabajoService;

	@Autowired()
	private ProvinciaService provinciaService;

	@Autowired()
	private MunicipioService municipioService;

	@Autowired()
	private LocalidadService localidadService;

	@Autowired()
	private CnaeJ73Service cnaej73Service;

	@Autowired()
	private ApartadoAnexoIService ab04b73s00Service;

	@Autowired()
	private EntidadGestoraColaboradoraService ab04b78s00Service;

	@Autowired()
	private TipoObraService tipoObraService;

	@Autowired()
	private PaisService paisService;

	@Autowired()
	private ApartadoAnexoIIService ab04b86s00Service;

	@Autowired()
	private ModalidadOrganizacionPreventivaService ab04b74s00Service;

	@Autowired()
	private EmpresaServicioPrevencionService empresaServicioPrevencionService;

	@Autowired()
	private EmpresaAuditoraService empresaAuditoraService;

	@Autowired()
	private TecnicoOsalanService tecnicoOsalanService;

	@Autowired()
	private SeccionesService seccionesService;
	@Autowired()
	private RegimenJuridicoService regimenJuridicoService;
	@Autowired()
	private TablonesService tablonesService;
	public static final String MOD_ORG_PREV = "MOD_ORG_PREV";

	public static final String TIP_DOC_IMP = "TIPO_DOC_IMPR";

	public static final String ROL_PART = "ROL_PART";

	private static final String TIPO_PROC_LIST = "TIPO_PROC_LIST";

	/**
	 * Devuelve la lista de Provincias, para un combo.
	 * 
	 * filterProvincia Provincia
	 * 
	 * @param filterProvincia
	 *            the filter provincia List<Provincia> Lista de objetos
	 *            correspondientes a la busqueda realizada.
	 * @return the combo provincia TH
	 */
	@RequestMapping(value = "provinciaTH", method = RequestMethod.GET)
	public @ResponseBody() List<Provincia> getComboProvinciaTH(
			@ModelAttribute() Provincia filterProvincia) {
		filterProvincia.setCodAutonomia(Constantes.COD_AUTONOMIA_PAIS_VASCO);
		return this.provinciaService.findAll(filterProvincia);
	}

	/**
	 * Devuelve la lista de Provincias, para un combo.
	 * 
	 * filterProvincia Provincia
	 * 
	 * @param filterProvincia
	 *            the filter provincia List<Provincia> Lista de objetos
	 *            correspondientes a la busqueda realizada.
	 * @return the combo provincia
	 */
	@RequestMapping(value = "provincia", method = RequestMethod.GET)
	public @ResponseBody() List<Provincia> getComboProvincia(
			@ModelAttribute() Provincia filterProvincia) {
		return this.provinciaService.findAll(filterProvincia);
	}

	/**
	 * Devuelve la lista de Provincias, para un combo.
	 * 
	 * filterProvincia Provincia
	 * 
	 * @param filterProvincia
	 *            the filter provincia List<Provincia> Lista de objetos
	 *            correspondientes a la busqueda realizada.
	 * @return the combo provincia ordenado TH
	 */
	@RequestMapping(value = "provinciaOrdenadoTH", method = RequestMethod.GET)
	public @ResponseBody() List<Provincia> getComboProvinciaOrdenadoTH(
			@ModelAttribute() Provincia filterProvincia) {

		List<Provincia> listaProvincias = this.provinciaService
				.findAll(filterProvincia);

		filterProvincia.setCodAutonomia(Constantes.COD_AUTONOMIA_PAIS_VASCO);
		List<Provincia> listaProvinciasPV = this.provinciaService
				.findAll(filterProvincia);

		List<Provincia> listaProvinciasRet = new ArrayList<Provincia>();
		for (Provincia provincia : listaProvincias) {
			if (!Constantes.COD_AUTONOMIA_PAIS_VASCO
					.equals(provincia.getCodAutonomia())) {
				listaProvinciasRet.add(provincia);
			}
		}
		listaProvinciasRet.addAll(0, listaProvinciasPV);

		return listaProvinciasRet;
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado
	 */
	@RequestMapping(value = "municipioEnlazado", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazado(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("terape056",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado empresa
	 */
	@RequestMapping(value = "municipioEnlazadoEmpresa", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoEmpresa(
			HttpServletRequest request) {
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provinciaEmp.codProvincia", request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado centro
	 */
	@RequestMapping(value = "municipioEnlazadoCentro", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoCentro(
			HttpServletRequest request) {
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provinciaCtr.codProvincia", request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado centro J 73
	 */
	@RequestMapping(value = "municipioEnlazadoCentroJ73", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoCentroJ73(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("provc001",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio fiscal enlazado alta centro J 73
	 */
	@RequestMapping(value = "municipioFiscalEnlazadoAltaCentroJ73", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioFiscalEnlazadoAltaCentroJ73(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("codprof001",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado alta centro J 73
	 */
	@RequestMapping(value = "municipioEnlazadoAltaCentroJ73", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoAltaCentroJ73(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("provc001",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado proyectista
	 */
	@RequestMapping(value = "municipioEnlazadoProyectista", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoProyectista(
			HttpServletRequest request) {
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provincia.codProvincia", request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado obra
	 */
	@RequestMapping(value = "municipioEnlazadoObra", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoObra(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("prvobr082",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado notificacion
	 */
	@RequestMapping(value = "municipioEnlazadoNotificacion", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoNotificacion(
			HttpServletRequest request) {
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provincia.codProvincia", request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Localidad, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Localidad> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo localidad enlazado obra
	 */
	@RequestMapping(value = "localidadEnlazadoObra", method = RequestMethod.GET)
	public @ResponseBody() List<Localidad> getComboLocalidadEnlazadoObra(
			HttpServletRequest request) {

		String codMunicipio = UtilWeb.getRequestParamEndsLike("munobr082",
				request);
		String codProvincia = UtilWeb.getRequestParamEndsLike("prvobr082",
				request);
		// String idCalle = UtilWeb.getRequestParamEndsLike("calle.idCalle",
		// request);

		// LOCALIDAD
		Localidad filterEntidadLocalidad = new Localidad();
		filterEntidadLocalidad.setCodMunicipio(codMunicipio);
		filterEntidadLocalidad.setCodProvincia(codProvincia);

		List<Localidad> listaLocalidades = new ArrayList<Localidad>();

		// Si son de la CAPV filtramos por el Tramo y Calle
		/*
		 * if (Constantes.DEL_ALAVA.equals(codProvincia) ||
		 * Constantes.DEL_GIPUZKOA.equals(codProvincia) ||
		 * Constantes.DEL_BIZKAIA.equals(codProvincia)) { // TRAMO Tramo
		 * filterTramo = new Tramo();
		 * filterTramo.setLocalidad(filterEntidadLocalidad); // CALLE Calle
		 * filterCalle = new Calle( !Utilities.isEmpty(idCalle) ?
		 * Long.valueOf(idCalle) : null); filterTramo.setCalle(filterCalle);
		 * 
		 * listaLocalidades = this.tramoService
		 * .findAllLocalidadesCalle(filterTramo); } else {
		 */
		// Si no son de la CAPV buscamos por Localidad directamente
		listaLocalidades = this.localidadService
				.findAll(filterEntidadLocalidad);
		// }

		Localidad localidadBlank = new Localidad(null, null, null, "---");
		listaLocalidades.add(0, localidadBlank);

		return listaLocalidades;
	}

	/**
	 * Devuelve la lista de Localidad, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Localidad> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo localidad enlazado centro
	 */
	@RequestMapping(value = "localidadEnlazadoCentro", method = RequestMethod.GET)
	public @ResponseBody() List<Localidad> getComboLocalidadEnlazadoCentro(
			HttpServletRequest request) {

		String codMunicipio = UtilWeb
				.getRequestParamEndsLike("municipioCtr.codMunicipio", request);
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provinciaCtr.codProvincia", request);
		// String idCalle = UtilWeb.getRequestParamEndsLike("calle.idCalle",
		// request);

		// LOCALIDAD
		Localidad filterEntidadLocalidad = new Localidad();
		filterEntidadLocalidad.setCodMunicipio(codMunicipio);
		filterEntidadLocalidad.setCodProvincia(codProvincia);

		List<Localidad> listaLocalidades = new ArrayList<Localidad>();

		// Si son de la CAPV filtramos por el Tramo y Calle
		/*
		 * if (Constantes.DEL_ALAVA.equals(codProvincia) ||
		 * Constantes.DEL_GIPUZKOA.equals(codProvincia) ||
		 * Constantes.DEL_BIZKAIA.equals(codProvincia)) { // TRAMO Tramo
		 * filterTramo = new Tramo();
		 * filterTramo.setLocalidad(filterEntidadLocalidad); // CALLE Calle
		 * filterCalle = new Calle( !Utilities.isEmpty(idCalle) ?
		 * Long.valueOf(idCalle) : null); filterTramo.setCalle(filterCalle);
		 * 
		 * listaLocalidades = this.tramoService
		 * .findAllLocalidadesCalle(filterTramo); } else {
		 */
		// Si no son de la CAPV buscamos por Localidad directamente
		listaLocalidades = this.localidadService
				.findAll(filterEntidadLocalidad);
		// }

		Localidad localidadBlank = new Localidad(null, null, null, "---");
		listaLocalidades.add(0, localidadBlank);

		return listaLocalidades;
	}

	/**
	 * Devuelve la lista de Localidad, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Localidad> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo localidad enlazado notificacion
	 */
	@RequestMapping(value = "localidadEnlazadoNotificacion", method = RequestMethod.GET)
	public @ResponseBody() List<Localidad> getComboLocalidadEnlazadoNotificacion(
			HttpServletRequest request) {

		String codMunicipio = UtilWeb
				.getRequestParamEndsLike("municipio.codMunicipio", request);
		String codProvincia = UtilWeb
				.getRequestParamEndsLike("provincia.codProvincia", request);
		// String idCalle = UtilWeb.getRequestParamEndsLike("calle.idCalle",
		// request);

		// LOCALIDAD
		Localidad filterEntidadLocalidad = new Localidad();
		filterEntidadLocalidad.setCodMunicipio(codMunicipio);
		filterEntidadLocalidad.setCodProvincia(codProvincia);

		List<Localidad> listaLocalidades = new ArrayList<Localidad>();

		// Si son de la CAPV filtramos por el Tramo y Calle
		/*
		 * if (Constantes.DEL_ALAVA.equals(codProvincia) ||
		 * Constantes.DEL_GIPUZKOA.equals(codProvincia) ||
		 * Constantes.DEL_BIZKAIA.equals(codProvincia)) { // TRAMO Tramo
		 * filterTramo = new Tramo();
		 * filterTramo.setLocalidad(filterEntidadLocalidad); // CALLE Calle
		 * filterCalle = new Calle( !Utilities.isEmpty(idCalle) ?
		 * Long.valueOf(idCalle) : null); filterTramo.setCalle(filterCalle);
		 * 
		 * listaLocalidades = this.tramoService
		 * .findAllLocalidadesCalle(filterTramo); } else {
		 */
		// Si no son de la CAPV buscamos por Localidad directamente
		listaLocalidades = this.localidadService
				.findAll(filterEntidadLocalidad);
		// }

		Localidad localidadBlank = new Localidad(null, null, null, "---");
		listaLocalidades.add(0, localidadBlank);

		return listaLocalidades;
	}

	/**
	 * Devuelve la lista de Localidad, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Localidad> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo localidad enlazado centro OS 2
	 */
	@RequestMapping(value = "localidadEnlazadoCentroOS2", method = RequestMethod.GET)
	public @ResponseBody() List<Localidad> getComboLocalidadEnlazadoCentroOS2(
			HttpServletRequest request) {

		String codMunicipio = UtilWeb.getRequestParamEndsLike("munctr",
				request);
		String codProvincia = UtilWeb.getRequestParamEndsLike("prvctr",
				request);
		// String idCalle = UtilWeb.getRequestParamEndsLike("calle.idCalle",
		// request);

		// LOCALIDAD
		Localidad filterEntidadLocalidad = new Localidad();
		filterEntidadLocalidad.setCodMunicipio(codMunicipio);
		filterEntidadLocalidad.setCodProvincia(codProvincia);

		List<Localidad> listaLocalidades = new ArrayList<Localidad>();

		// Si son de la CAPV filtramos por el Tramo y Calle
		/*
		 * if (Constantes.DEL_ALAVA.equals(codProvincia) ||
		 * Constantes.DEL_GIPUZKOA.equals(codProvincia) ||
		 * Constantes.DEL_BIZKAIA.equals(codProvincia)) { // TRAMO Tramo
		 * filterTramo = new Tramo();
		 * filterTramo.setLocalidad(filterEntidadLocalidad); // CALLE Calle
		 * filterCalle = new Calle( !Utilities.isEmpty(idCalle) ?
		 * Long.valueOf(idCalle) : null); filterTramo.setCalle(filterCalle);
		 * 
		 * listaLocalidades = this.tramoService
		 * .findAllLocalidadesCalle(filterTramo); } else {
		 */
		// Si no son de la CAPV buscamos por Localidad directamente
		listaLocalidades = this.localidadService
				.findAll(filterEntidadLocalidad);
		// }

		Localidad localidadBlank = new Localidad(null, null, null, "---");
		listaLocalidades.add(0, localidadBlank);

		return listaLocalidades;
	}

	/**
	 * /** Devuelve los tipos de aperturas de centros de trabajo.
	 * 
	 * List<Ab04b71s00> Lista de objetos correspondientes a la busqueda
	 * realizada.
	 * 
	 * @return the combo tipos aperturas
	 */
	@RequestMapping(value = "tiposAperturas", method = RequestMethod.GET)
	public @ResponseBody() List<TipoApertura> getComboTiposAperturas() {
		return this.tiposAperturasService.findAll(new TipoApertura(), null);
	}

	/**
	 * Devuelve los tipos de aperturas de centros de trabajo.
	 * 
	 * List<Ab04b71s00> Lista de objetos correspondientes a la busqueda
	 * realizada.
	 * 
	 * @return the combo clases centros trabajo
	 */
	@RequestMapping(value = "clasesCentrosTrabajo", method = RequestMethod.GET)
	public @ResponseBody() List<ClaseCentroTrabajo> getComboClasesCentrosTrabajo() {
		return this.clasesCentrosTrabajoService
				.findAll(new ClaseCentroTrabajo(), null);
	}

	/**
	 * Cargar combo periodo presentacion.
	 * 
	 * List<Tablones> periodo presentacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "periodoPresentacion", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboPeriodoPresentacion() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(PeriodoPresentacionImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo resultado estudio doc.
	 * 
	 * List<Tablones>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "resultadoEstudioDoc", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboResultadoEstudioDoc() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(ResultadoEstudioDocImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo estado expediente.
	 * 
	 * List<Tablones> estado expediente
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "estadoExpediente", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboEstadoExpediente() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(EstadoCierreImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo tipo cambio.
	 * 
	 * List<Tablones> tipo cambio
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoCambio", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboTipoCambio() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(TipoCambioImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo estado visita osalan.
	 * 
	 * List<Tablones> estado visita osalan
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "estadoVisitaOsalan", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboEstadoVisitaOsalan() {
		List<Tablones> lista = new ArrayList<Tablones>();
		// lista.add(0, new Tablones());
		lista.addAll(EstadoVisitaOsalanImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Gets the by cnae.
	 * 
	 * cnae String
	 * 
	 * @param cnae
	 *            the cnae Ramas
	 * @return the by cnae
	 */
	@RequestMapping(value = "getByCnae/{cnae}", method = RequestMethod.GET)
	public @ResponseBody() CnaeJ73 getByCnae(@PathVariable() String cnae) {
		CnaeJ73 cnaej73 = new CnaeJ73();
		cnaej73.setCnae003(cnae);
		CnaeJ73 ramaCnae = this.cnaej73Service.findByCnae(cnaej73);
		if (ramaCnae != null) {
			return ramaCnae;
		}
		throw new ErrorGenericoException("");
	}

	/**
	 * Method 'getRemoteAutocomplete'.
	 * 
	 * q String c boolean
	 * 
	 * @param q
	 *            the q
	 * @param c
	 *            the c List<CausaAlegada>
	 * @return the remote autocomplete
	 */
	@RequestMapping(value = "getCnaeAutocomplete", method = RequestMethod.GET)
	public @ResponseBody() List<CnaeJ73> getRemoteAutocomplete(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		CnaeJ73 cnaej73 = new CnaeJ73();
		cnaej73.setDesc003(q);

		return this.cnaej73Service.findAllForAutocomplete(cnaej73, null, c);
	}

	/**
	 * Method 'getRemoteAutocomplete'.
	 * 
	 * q String c boolean
	 * 
	 * @param q
	 *            the q
	 * @param c
	 *            the c List<CausaAlegada>
	 * @return the remote autocomplete emp
	 */
	@RequestMapping(value = "getCnaeEmpAutocomplete", method = RequestMethod.GET)
	public @ResponseBody() List<CnaeJ73> getRemoteAutocompleteEmp(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		CnaeJ73 cnaej73 = new CnaeJ73();
		cnaej73.setDesc003(q);

		return this.cnaej73Service.findAllForAutocomplete(cnaej73, null, c);
	}

	/**
	 * Method 'getRemoteAutocomplete'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getApartadoAnexoI", method = RequestMethod.GET)
	public @ResponseBody() List<ApartadoAnexoI> cargarComboApartadoAnexoI() {

		return this.ab04b73s00Service.findAll(new ApartadoAnexoI(), null);
	}

	/**
	 * Method 'getRemoteAutocomplete'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getEntidadesColaboradorasGestoras", method = RequestMethod.GET)
	public @ResponseBody() List<EntidadGestoraColaboradora> cargarComboEntidadesColaboradorasGestoras() {

		List<EntidadGestoraColaboradora> lista = this.ab04b78s00Service
				.findAll(new EntidadGestoraColaboradora(), null);
		EntidadGestoraColaboradora e = new EntidadGestoraColaboradora(
				Constantes.VALUE_OTRO, Constantes.OTRO_EU, Constantes.OTRO_ES,
				null);
		lista.add(0, e);

		return lista;
	}

	/**
	 * Cargar combo tipo identif.
	 * 
	 * List<Tablones> tipo identificacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoIdentificacion", method = RequestMethod.GET)
	public @ResponseBody() List<ElementoCombo> cargarComboTipoIdentif() {
		return Constantes.COMBO_TIPO_IDENTIF;
	}

	/**
	 * Cargar combo tipo identif.
	 * 
	 * List<Tablones> tipo identificacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoIdentificacionConNie", method = RequestMethod.GET)
	public @ResponseBody() List<ElementoCombo> cargarComboTipoIdentifConNie() {
		return Constantes.COMBO_TIPO_IDENTIF_CON_NIE;
	}

	/**
	 * Cargar combo tipo identif.
	 * 
	 * List<Tablones> tipo identificacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoIdentificacionCoord", method = RequestMethod.GET)
	public @ResponseBody() List<ElementoCombo> cargarComboTipoIdentifCoord() {
		return Constantes.COMBO_TIPO_IDENTIF_COORD;
	}

	/**
	 * Cargar combo tipo comunicacion PRL.
	 * 
	 * List<Tablones> tipo comunicacion PRL
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoComunicacionPRL", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboTipoComunicacionPRL() {
		List<Tablones> lista = new ArrayList<Tablones>();
		// lista.add(0, new Tablones());
		lista.addAll(TipoComunicacionPRLImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo tipo comunicacion.
	 * 
	 * request the request
	 * 
	 * @param request
	 *            the request List<Tablones> tipo comunicacion
	 * @return the list
	 */
	@RequestMapping(value = "tipoComunicacion", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboTipoComunicacion(
			HttpServletRequest request) {
		List<Tablones> lista = new ArrayList<Tablones>();

		List<Tablones> listTablones = TipoComunicacionImpl.getInstance()
				.getValues();

		// Condicion para comprobar si depende del rol que tenga que se muestre
		// todas las opciones o no
		if ("si".equals(request.getParameter("seguridadPerfil"))) {
			Vector<String> profiles = UtilSeguridad.getInstance()
					.getUserCredentials().getUserProfiles();

			boolean tramitador = UtilidadesWar.vectorContieneElement(profiles,
					UtilSeguridad.getProperty("seg.inst.rol.tramitador.araba"),
					UtilSeguridad
							.getProperty("seg.inst.rol.tramitador.gipuzkoa"),
					UtilSeguridad
							.getProperty("seg.inst.rol.tramitador.bizkaia"),
					UtilSeguridad.getProperty("seg.inst.rol.administrador"));

			boolean osalan = UtilidadesWar.vectorContieneElement(profiles,
					UtilSeguridad.getProperty(
							"seg.inst.rol.tramitador.osalan.araba"),
					UtilSeguridad.getProperty(
							"seg.inst.rol.tramitador.osalan.bizkaia"),
					UtilSeguridad.getProperty(
							"seg.inst.rol.tramitador.osalan.gipuzkoa"));

			// No devuelvo error si la lista esta vacia porque aqui solo tiene
			// que entrar con el rol de tramitador o tramitador osalan
			for (int i = listTablones.size() - 1; i >= 0; i--) {
				Tablones tablon = listTablones.get(i);

				if (!tramitador && Constantes.TIPO_COMUNICACION_REENVIO_APERTURA
						.equals(tablon.getCodigo088())) {
					listTablones.remove(i);
				}
				if (!osalan && (Constantes.TIPO_COMUNICACION_REENVIO_OS3
						.equals(tablon.getCodigo088())
						|| Constantes.TIPO_COMUNICACION_REENVIO_OS2
								.equals(tablon.getCodigo088()))) {
					listTablones.remove(i);
				}
			}
		}
		lista.addAll(listTablones);
		return lista;
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado centro trabajo
	 */
	@RequestMapping(value = "municipioEnlazadoCentroTrabajo", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoCentroTrabajo(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("prvctr",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Devuelve la lista de Municipio, para un combo.
	 * 
	 * request HttpServletRequest
	 * 
	 * @param request
	 *            the request List<Municipio> Lista de objetos correspondientes
	 *            a la busqueda realizada.
	 * @return the combo municipio enlazado territorio historico
	 */
	@RequestMapping(value = "municipioEnlazadoTerritorioHistorico", method = RequestMethod.GET)
	public @ResponseBody() List<Municipio> getComboMunicipioEnlazadoTerritorioHistorico(
			HttpServletRequest request) {
		String codProvincia = UtilWeb.getRequestParamEndsLike("prvemp",
				request);
		Municipio filterMunicipio = new Municipio();
		filterMunicipio.setCodProvincia(codProvincia);
		return this.municipioService.findAll(filterMunicipio);
	}

	/**
	 * Method 'cargarComboTipoObra'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoObra", method = RequestMethod.GET)
	public @ResponseBody() List<TipoObra> cargarComboTipoObra() {

		return this.tipoObraService.findAll(new TipoObra(), null);
	}

	/**
	 * Cargar combo unidad temporal dur obra.
	 * 
	 * List<Tablones> unidad temporal duracion obra
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "unidadTemporalDurObra", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboUnidadTemporalDurObra() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(UniTempDuracionObraImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo canal presentacion.
	 * 
	 * List<Tablones> canal presentacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "canalPresentacion", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboCanalPresentacion() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.add(0, new Tablones());
		lista.addAll(CanalPresentacionImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Devuelve la lista de paises, para un combo.
	 * 
	 * List<Pais> Lista de objetos correspondientes a la busqueda realizada.
	 * 
	 * @return the combo pais
	 */
	@RequestMapping(value = "pais", method = RequestMethod.GET)
	public @ResponseBody() List<Pais> getComboPais() {
		List<Pais> listaPaises = this.paisService.findAll(new Pais(), null);

		List<Pais> listaPaisesRet = new ArrayList<Pais>();
		for (Pais paisAux : listaPaises) {
			if (Constantes.ID_PAIS_ESPANA.equals(paisAux.getId())) {
				listaPaisesRet.add(0, paisAux);
			} else {
				listaPaisesRet.add(paisAux);
			}
		}

		return listaPaisesRet;
	}

	/**
	 * Method 'getApartadoAnexoII'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getApartadoAnexoII", method = RequestMethod.GET)
	public @ResponseBody() List<ApartadoAnexoII> cargarComboApartadoAnexoII() {

		return this.ab04b86s00Service.findAll(new ApartadoAnexoII(), null);
	}

	/**
	 * Method 'getModalidadOrganizacionPreventiva'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getModalidadOrganizacionPreventiva", method = RequestMethod.GET)
	public @ResponseBody() List<ModalidadOrganizacionPreventiva> cargarComboModalidadOrganizacionPreventiva() {

		return this.ab04b74s00Service
				.findAll(new ModalidadOrganizacionPreventiva(), null);
	}

	/**
	 * Method 'getModalidadOrganizacionPreventivaVig'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getModalidadOrganizacionPreventivaVig", method = RequestMethod.GET)
	public @ResponseBody() List<ModalidadOrganizacionPreventiva> cargarComboModalidadOrganizacionPreventivaVig() {

		List<ModalidadOrganizacionPreventiva> lista = this.ab04b74s00Service
				.findAll(new ModalidadOrganizacionPreventiva(), null);

		lista.remove(0);
		lista.remove(0);

		return lista;
	}

	/**
	 * Method 'getServiciosPrevencion'.
	 * 
	 * List<EmpresaServicioPrevencion>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getServiciosPrevencion", method = RequestMethod.GET)
	public @ResponseBody() List<EmpresaServicioPrevencion> cargarComboServiciosPrevencion() {

		List<EmpresaServicioPrevencion> lista = this.empresaServicioPrevencionService
				.findAll(new EmpresaServicioPrevencion(), null);

		EmpresaServicioPrevencion e = new EmpresaServicioPrevencion(
				Constantes.VALUE_OTRO, Constantes.OTRO_EU, Constantes.OTRO_ES,
				null);

		lista.add(0, e);

		return lista;
	}

	/**
	 * Method 'getEmpresasAuditoras'.
	 * 
	 * List<EmpresaAuditora>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getEmpresasAuditoras", method = RequestMethod.GET)
	public @ResponseBody() List<EmpresaAuditora> cargarComboEmpresasAuditoras() {

		List<EmpresaAuditora> lista = this.empresaAuditoraService
				.findAll(new EmpresaAuditora(), null);

		EmpresaAuditora e = new EmpresaAuditora(Constantes.VALUE_OTRO,
				Constantes.OTRO_EU, Constantes.OTRO_ES, null);

		lista.add(0, e);

		return lista;
	}

	/**
	 * Cargar combo estado comunicacion PRL.
	 * 
	 * List<Tablones> estado comunicacion
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "estadoComunicacionPRL", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboEstadoComunicacionPRL() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.addAll(EstadoComunicacionPRLImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Method 'getTecnicosOsalan'.
	 * 
	 * List<TecnicoOsalan>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getTecnicosOsalan", method = RequestMethod.GET)
	public @ResponseBody() List<TecnicoOsalan> cargarComboTecnicosOsalan() {

		TecnicoOsalan tecnico = new TecnicoOsalan();
		tecnico.setT04Tabla(Constantes.T04_TABLA_TECNI);
		tecnico.setT04Baja(Constantes.VALUE_NO);

		return this.tecnicoOsalanService.findAll(tecnico, null);
	}

	/**
	 * Cargar combo tipo participante.
	 * 
	 * List<Tablones> estado expediente
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tipoParticipante", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboTipoParticipante() {
		Tablones tablon = new Tablones();
		tablon.setCodtabla088(ComboController.ROL_PART);
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();

		return this.tablonesService.findAllLike(tablon, jQGridRequestDto,
				false);
	}

	/**
	 * Cargar combo tipo participante.
	 * 
	 * List<Tablones> estado expediente
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "estadosAcuse", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboEstadosAcuses() {
		Tablones tablon = new Tablones();
		tablon.setCodtabla088("EST_ACU");
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();

		return this.tablonesService.findAllLike(tablon, jQGridRequestDto,
				false);
	}

	/**
	 * Method 'cargarCombosCausaAlegada'.
	 * 
	 * List<CausaAlegada>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "secciones", method = RequestMethod.GET)
	public @ResponseBody() List<Secciones> cargarComboSecciones() {
		return this.seccionesService.findAll(new Secciones(), null);
	}

	/**
	 * Method 'cargarComboRegimenJuridico'.
	 * 
	 * List<CausaAlegada>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "regimenJuridico", method = RequestMethod.GET)
	public @ResponseBody() List<RegimenJuridico> cargarComboRegimenJuridico() {
		return this.regimenJuridicoService.findAll(new RegimenJuridico(), null);
	}

	/**
	 * Method 'getModalidadOrganizacionPreventiva'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "getModalidadOrganizacionPreventivaAper", method = RequestMethod.GET)
	public @ResponseBody() List<ModalidadOrganizacionPreventiva> cargarComboModalidadOrganizacionPreventivaAper() {
		Tablones tablon = new Tablones();
		tablon.setCodtabla088(ComboController.MOD_ORG_PREV);
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();
		List<Tablones> listaMod = new ArrayList<Tablones>();
		listaMod.add(0, new Tablones());
		listaMod.addAll(this.tablonesService.findAllLike(tablon,
				jQGridRequestDto, false));

		return TransformarListaaMOP(listaMod);
	}

	/**
	 * Method 'getModalidadOrganizacionPreventiva'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the tipos documentosa imprimir
	 */
	@RequestMapping(value = "getTiposDocumentosaImprimir", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> getTiposDocumentosaImprimir() {
		Tablones tablon = new Tablones();
		tablon.setCodtabla088(ComboController.TIP_DOC_IMP);
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();

		return (List<Tablones>) this.tablonesService.findAllLike(tablon,
				jQGridRequestDto, false);

	}

	/**
	 * Method 'getModalidadOrganizacionPreventiva'.
	 * 
	 * List<ApartadoAnexoI>
	 * 
	 * @return the tipo comunicacion listado
	 */
	@RequestMapping(value = "tipoComunicacionListado", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> getTipoComunicacionListado() {
		Tablones tablon = new Tablones();
		tablon.setCodtabla088(ComboController.TIPO_PROC_LIST);
		JQGridRequestDto jQGridRequestDto = new JQGridRequestDto();

		return (List<Tablones>) this.tablonesService.findAllLike(tablon,
				jQGridRequestDto, false);

	}

	/**
	 * Method 'TransformarListaaMOP'.
	 * 
	 * listaMod List<Tablones>
	 * 
	 * @param listaMod
	 *            the lista mod List<ModalidadOrganizacionPreventiva>
	 * @return the list
	 */
	private List<ModalidadOrganizacionPreventiva> TransformarListaaMOP(
			List<Tablones> listaMod) {
		List<ModalidadOrganizacionPreventiva> listaMop = new ArrayList<ModalidadOrganizacionPreventiva>();
		ModalidadOrganizacionPreventiva mop;

		for (Tablones mod : listaMod) {
			mop = new ModalidadOrganizacionPreventiva();
			mop.setTipmpr074(mod.getCodigo088());
			mop.setDesmprEs074(mod.getDescripcion088());
			mop.setDesmprEu074(mod.getDescripcionEus088());
			listaMop.add(mop);
		}

		return listaMop;
	}

	/**
	 * Cargar combo estados envio.
	 * 
	 * List<Tablones> estados envio
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "estadosEnvio", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboEstadosEnvio() {
		List<Tablones> lista = new ArrayList<Tablones>();
		lista.addAll(EstadosEnvioImpl.getInstance().getValues());
		return lista;
	}

	/**
	 * Cargar combo tipos expediente.
	 * 
	 * List<Tablones> tipos expediente
	 * 
	 * @return the list
	 */
	@RequestMapping(value = "tiposExpediente", method = RequestMethod.GET)
	public @ResponseBody() List<Tablones> cargarComboTiposExpediente() {
		List<Tablones> lista = new ArrayList<Tablones>();

		lista.addAll(TiposExpedienteImpl.getInstance().getValues());

		return lista;
	}
}
